<?php
require_once '../../core/bootstrap.php';

header('Content-Type: application/json');

// Auth check
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['user_role'], ['super_admin', 'admin', 'league_manager'])) {
    http_response_code(403);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

$team_id = filter_input(INPUT_GET, 'team_id', FILTER_VALIDATE_INT);
if (!$team_id) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid Team ID']);
    exit();
}

$playerModel = new Player();
// Fetch players for the team
$players = $playerModel->getPlayersByTeamId($team_id);

echo json_encode($players);
?>
