<?php
// c:\xampp\htdocs\smart_football\admin\board_wallet.php
$pageTitle = 'Board Wallet & Withdrawals';
include_once 'includes/header.php';

// --- Admin Check ---
if (!in_array($_SESSION['admin_user_role'] ?? '', ['admin', 'super_admin'])) {
    header('Location: dashboard.php');
    exit();
}

$walletModel = new Wallet();
$settingModel = new Setting();
$userModel = new User();

// Get Board Wallet (Entity Type: board, ID: 0)
$board_wallet = $walletModel->getOrCreateWallet('board', 0);

// Get Currency
$settings = $settingModel->getAll();
$currency_symbol = ($settings['system_currency'] ?? 'USD') === 'ZMW' ? 'K' : '$';

// Fetch Recent Withdrawal Requests
$db = new Database();
$db->query("SELECT wr.*, u.first_name, u.last_name 
            FROM withdrawal_requests wr 
            LEFT JOIN users u ON wr.requested_by = u.id 
            WHERE wr.wallet_id = :wallet_id 
            ORDER BY wr.created_at DESC LIMIT 20");
$db->bind(':wallet_id', $board_wallet->id);
$requests = $db->resultSet();

include_once 'includes/sidebar.php';
?>

<h1>Board Wallet</h1>

<?php if (isset($_SESSION['flash_message'])): ?>
    <?php
    $msg = $_SESSION['flash_message'];
    $type = is_array($msg) ? ($msg['type'] ?? 'success') : ($_SESSION['flash_type'] ?? 'success');
    $text = is_array($msg) ? ($msg['text'] ?? '') : $msg;
    unset($_SESSION['flash_message'], $_SESSION['flash_type']);
    ?>
    <div class="message <?php echo $type; ?>">
        <?php echo $text; ?>
    </div>
<?php endif; ?>

<div class="dashboard-section">
    <div class="wallet-overview-card" style="background: #fff; padding: 25px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.05); display: flex; justify-content: space-between; align-items: center;">
        <div>
            <h3 style="margin: 0 0 5px 0; color: #7f8c8d; font-size: 0.9rem; text-transform: uppercase;">Current Balance</h3>
            <div style="font-size: 2.5rem; font-weight: 800; color: #2c3e50;">
                <?php echo $currency_symbol . number_format($board_wallet->balance, 2); ?>
            </div>
        </div>
        <button class="btn" onclick="document.getElementById('withdrawalModal').style.display='flex'">
            <i class="fa-solid fa-money-bill-transfer"></i> Request Withdrawal
        </button>
    </div>
</div>

<div class="dashboard-section">
    <h3>Withdrawal History</h3>
    <div class="table-wrapper">
        <table class="styled-table">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Requested By</th>
                    <th>Amount</th>
                    <th>Details</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($requests)): ?>
                    <?php foreach ($requests as $req): ?>
                        <tr>
                            <td><?php echo date('d M Y, H:i', strtotime($req->created_at)); ?></td>
                            <td><?php echo htmlspecialchars($req->first_name . ' ' . $req->last_name); ?></td>
                            <td><?php echo $currency_symbol . number_format($req->amount, 2); ?></td>
                            <td><?php echo htmlspecialchars($req->details); ?></td>
                            <td>
                                <span class="badge status-<?php echo $req->status; ?>" style="padding: 4px 8px; border-radius: 4px; text-transform: uppercase; font-size: 0.8rem; font-weight: bold; 
                                    background: <?php echo $req->status === 'approved' ? '#d4edda' : ($req->status === 'rejected' ? '#f8d7da' : '#fff3cd'); ?>;
                                    color: <?php echo $req->status === 'approved' ? '#155724' : ($req->status === 'rejected' ? '#721c24' : '#856404'); ?>;">
                                    <?php echo ucfirst($req->status); ?>
                                </span>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="5">No withdrawal requests found.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Withdrawal Modal -->
<div id="withdrawalModal" class="modal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); align-items: center; justify-content: center; z-index: 1000;">
    <div class="modal-content" style="background: #fff; padding: 30px; border-radius: 8px; width: 90%; max-width: 500px;">
        <h2 style="margin-top: 0;">Request Withdrawal</h2>
        <p>Funds will be transferred to the specified mobile account upon Super Admin approval.</p>
        
        <form action="process_board_withdrawal.php" method="POST">
            <input type="hidden" name="wallet_id" value="<?php echo $board_wallet->id; ?>">
            
            <div class="form-group">
                <label>Amount (<?php echo $currency_symbol; ?>)</label>
                <input type="number" name="amount" step="0.01" min="1" max="<?php echo $board_wallet->balance; ?>" required style="width: 100%; padding: 10px; margin-bottom: 15px; border: 1px solid #ddd; border-radius: 4px;">
            </div>
            
            <div class="form-group">
                <label>Mobile Account / Bank Details</label>
                <textarea name="details" rows="3" required placeholder="e.g. Airtel Money 097xxxxxxx, John Doe" style="width: 100%; padding: 10px; margin-bottom: 15px; border: 1px solid #ddd; border-radius: 4px;"></textarea>
            </div>

            <div style="text-align: right;">
                <button type="button" class="btn btn-secondary" onclick="document.getElementById('withdrawalModal').style.display='none'" style="margin-right: 10px;">Cancel</button>
                <button type="submit" class="btn">Submit Request</button>
            </div>
        </form>
    </div>
</div>

<?php include_once 'includes/footer.php'; ?>
