<?php
$pageTitle = 'Edit Fixture';
include_once 'includes/header.php';

$fixtureModel = new Fixture();
$leagueModel = new League();
$teamModel = new Team();
$userModel = new User();
$error = '';

$fixture_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$fixture_id) {
    header('Location: manage_fixtures.php');
    exit();
}

$fixture = $fixtureModel->findById($fixture_id);
if (!$fixture) {
    header('Location: manage_fixtures.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = [
        'id' => $fixture_id,
        'league_id' => filter_input(INPUT_POST, 'league_id', FILTER_VALIDATE_INT),
        'home_team_id' => filter_input(INPUT_POST, 'home_team_id', FILTER_VALIDATE_INT),
        'away_team_id' => filter_input(INPUT_POST, 'away_team_id', FILTER_VALIDATE_INT),
        'match_datetime' => $_POST['match_datetime'] ?? '',
        'gameweek' => filter_input(INPUT_POST, 'gameweek', FILTER_VALIDATE_INT),
        'venue' => trim($_POST['venue'] ?? ''),
        'referee_id' => filter_input(INPUT_POST, 'referee_id', FILTER_VALIDATE_INT) ?: null,
        'commissioner_id' => filter_input(INPUT_POST, 'commissioner_id', FILTER_VALIDATE_INT) ?: null,
    ];

    if (empty($data['league_id']) || empty($data['home_team_id']) || empty($data['away_team_id']) || empty($data['match_datetime'])) {
        $error = 'League, teams, and match date/time are required.';
    } elseif ($data['home_team_id'] === $data['away_team_id']) {
        $error = 'Home and away teams cannot be the same.';
    } else {
        if ($fixtureModel->update($data)) {
            $_SESSION['flash_message'] = 'Fixture updated successfully!';
            header('Location: manage_fixtures.php');
            exit();
        } else {
            $error = 'Failed to update fixture.';
        }
    }
}

$leagues = $leagueModel->getAll();
$teams = $teamModel->getAllWithDetails();
$referees = $userModel->getPotentialManagers(['referee']);
$commissioners = $userModel->getPotentialManagers(['commissioner']);

include_once 'includes/sidebar.php';
?>

<h1>Edit Fixture</h1>

<?php if ($error): ?><div class="message error"><?php echo $error; ?></div><?php endif; ?>

<div class="form-container">
    <form action="edit_fixture.php?id=<?php echo $fixture_id; ?>" method="POST">
        <div class="form-group"><label for="league_id">League</label>
            <select name="league_id" id="league_id" required>
                <?php foreach ($leagues as $league): ?><option value="<?php echo $league->id; ?>" <?php echo ($league->id == $fixture->league_id) ? 'selected' : ''; ?>><?php echo htmlspecialchars($league->name); ?></option><?php endforeach; ?>
            </select>
        </div>
        <div class="form-group"><label for="home_team_id">Home Team</label>
            <select name="home_team_id" id="home_team_id" required>
                <?php foreach ($teams as $team): ?><option value="<?php echo $team->id; ?>" <?php echo ($team->id == $fixture->home_team_id) ? 'selected' : ''; ?>><?php echo htmlspecialchars($team->club_name . ' - ' . $team->name); ?></option><?php endforeach; ?>
            </select>
        </div>
        <div class="form-group"><label for="away_team_id">Away Team</label>
            <select name="away_team_id" id="away_team_id" required>
                <?php foreach ($teams as $team): ?><option value="<?php echo $team->id; ?>" <?php echo ($team->id == $fixture->away_team_id) ? 'selected' : ''; ?>><?php echo htmlspecialchars($team->club_name . ' - ' . $team->name); ?></option><?php endforeach; ?>
            </select>
        </div>
        <div class="form-group"><label for="match_datetime">Match Date & Time</label><input type="datetime-local" name="match_datetime" id="match_datetime" value="<?php echo date('Y-m-d\TH:i', strtotime($fixture->match_datetime)); ?>" required></div>
        <div class="form-group"><label for="gameweek">Gameweek</label><input type="number" name="gameweek" id="gameweek" value="<?php echo htmlspecialchars($fixture->gameweek); ?>" min="1"></div>
        <div class="form-group"><label for="venue">Venue</label><input type="text" name="venue" id="venue" value="<?php echo htmlspecialchars($fixture->venue); ?>"></div>
        <div class="form-group"><label for="referee_id">Referee</label>
            <select name="referee_id" id="referee_id">
                <option value="">-- Unassigned --</option>
                <?php foreach ($referees as $ref): ?><option value="<?php echo $ref->id; ?>" <?php echo ($ref->id == $fixture->referee_id) ? 'selected' : ''; ?>><?php echo htmlspecialchars($ref->first_name . ' ' . $ref->last_name); ?></option><?php endforeach; ?>
            </select>
        </div>
        <div class="form-group"><label for="commissioner_id">Commissioner</label>
            <select name="commissioner_id" id="commissioner_id">
                <option value="">-- Unassigned --</option>
                <?php foreach ($commissioners as $com): ?><option value="<?php echo $com->id; ?>" <?php echo ($com->id == $fixture->commissioner_id) ? 'selected' : ''; ?>><?php echo htmlspecialchars($com->first_name . ' ' . $com->last_name); ?></option><?php endforeach; ?>
            </select>
        </div>
        <button type="submit" class="btn">Update Fixture</button>
    </form>
</div>

<?php include_once 'includes/footer.php'; ?>