<?php
$pageTitle = 'Fantasy Points Log';
include 'includes/header.php';

// --- Admin Authentication & Authorization ---
if (!in_array($_SESSION['admin_user_role'], ['admin', 'super_admin'])) {
    header('Location: dashboard.php');
    exit();
}

// --- Instantiate Models ---
$fantasyPointsModel = new FantasyPoints();

// --- Get Gameweek from URL ---
$gameweek = filter_input(INPUT_GET, 'gameweek', FILTER_VALIDATE_INT);
if (!$gameweek) {
    $gameweek = 1; // Default to gameweek 1 if none is specified
}

// --- Fetch Fantasy Points Log ---
$points_log = $fantasyPointsModel->getFantasyPointsLog($gameweek);

include 'includes/sidebar.php';
?>

<div class="page-content">
    <div class="matches-header">
        <h1>Fantasy Points Log - Gameweek <?php echo htmlspecialchars($gameweek); ?></h1>
        <form method="GET" action="fantasy_points_log.php" style="display:inline;">
            <label for="gameweek">View Another Gameweek:</label>
            <input type="number" id="gameweek" name="gameweek" min="1" value="<?php echo htmlspecialchars($gameweek); ?>">
            <button type="submit" class="btn-sm">View</button>
        </form>
    </div>

    <div class="dashboard-section">
        <?php if (!empty($points_log)): ?>
            <div class="table-wrapper">
                <table class="styled-table">
                    <thead>
                        <tr>
                            <th>Player</th>
                            <th>Position</th>
                            <th>Fixture</th>
                            <th>Total Points</th>
                            <th>Minutes Played</th>
                            <th>Breakdown</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($points_log as $log_entry): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($log_entry->first_name . ' ' . $log_entry->last_name); ?></td>
                                <td><?php echo htmlspecialchars($log_entry->position); ?></td>
                                <td><?php echo htmlspecialchars($log_entry->home_team_id) . ' vs ' . htmlspecialchars($log_entry->away_team_id); ?></td>
                                <td><?php echo htmlspecialchars($log_entry->total_points); ?></td>
                                <td><?php echo htmlspecialchars($log_entry->total_minutes); ?></td>
                                <td><?php echo htmlspecialchars($log_entry->breakdown); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p class="no-data-msg">No fantasy points data found for gameweek <?php echo htmlspecialchars($gameweek); ?>.</p>
        <?php endif; ?>
    </div>
</div>

<style>
.matches-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
}
.matches-header form {
    display: flex;
    align-items: center;
    gap: 10px;
}
.matches-header form label {
    font-weight: bold;
}
</style>

<?php
include 'includes/footer.php';
?>