<?php
require_once '../core/bootstrap.php';

$db = new Database();
echo "<h1>Fixing Database Schema...</h1>";

try {
    $db->query("ALTER TABLE fantasy_teams ADD COLUMN free_transfers INT(11) NOT NULL DEFAULT 1");
    $db->execute();
    echo "Success: Added 'free_transfers' column.<br>";
} catch (Exception $e) {
    echo "Info: 'free_transfers' column might already exist.<br>";
}

try {
    $db->query("ALTER TABLE fantasy_teams ADD COLUMN last_gw_update INT(11) DEFAULT 0");
    $db->execute();
    echo "Success: Added 'last_gw_update' column.<br>";
} catch (Exception $e) {
    echo "Info: 'last_gw_update' column might already exist.<br>";
}

echo "<br><strong>Database updated. You can now use the fantasy features.</strong>";
?>