<?php
$pageTitle = 'Generate Season Fixtures';
include_once 'includes/header.php';

// Instantiate Models
$leagueModel = new League();
$seasonModel = new Season();
$settingModel = new Setting();

// Fetch Data
$leagues = $leagueModel->getAll();
$seasons = $seasonModel->getAll();
$current_season = $seasons[0]->name ?? date('Y') . '/' . (date('Y') + 1); // Default to first season or current year

// Fetch Settings for display
$settings = $settingModel->getAll();
$match_duration = $settings['full_time_duration'] ?? 90;
$half_time_break = $settings['half_time_duration'] ?? 15;

include_once 'includes/sidebar.php';
?>

<h1>Generate Season Fixtures</h1>
<p>Automatically generate a random round-robin schedule for an entire league season.</p>

<div class="dashboard-section">
    <form action="generate_fixtures_process.php" method="POST" class="styled-form" style="max-width: 800px;">
        
        <div class="form-group">
            <label for="season">Season</label>
            <input type="text" name="season" id="season" value="<?php echo htmlspecialchars($current_season); ?>" readonly style="background-color: #f0f0f0; cursor: not-allowed;">
        </div>

        <div class="form-group">
            <label for="league_id">League</label>
            <select name="league_id" id="league_id" required>
                <option value="">-- Select League --</option>
                <?php foreach ($leagues as $league): ?>
                    <option value="<?php echo $league->id; ?>"><?php echo htmlspecialchars($league->name); ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="form-group">
            <label>Number of Legs</label>
            <div class="radio-group" style="display: flex; gap: 20px;">
                <label><input type="radio" name="legs" value="1"> 1 Leg (Single Round Robin)</label>
                <label><input type="radio" name="legs" value="2" checked> 2 Legs (Home & Away)</label>
            </div>
        </div>

        <div class="form-group">
            <label>Match Days</label>
            <div class="checkbox-group" style="display: flex; gap: 15px; flex-wrap: wrap;">
                <label><input type="checkbox" name="match_days[]" value="Saturday" checked> Saturday</label>
                <label><input type="checkbox" name="match_days[]" value="Sunday" checked> Sunday</label>
                <label><input type="checkbox" name="match_days[]" value="Tuesday"> Tuesday</label>
                <label><input type="checkbox" name="match_days[]" value="Wednesday"> Wednesday</label>
                <label><input type="checkbox" name="match_days[]" value="Friday"> Friday</label>
            </div>
            <small style="color: #666;">Matches for a gameweek will be distributed across these selected days.</small>
        </div>

        <div class="form-group">
            <label>Football Grounds</label>
            <div id="grounds-container">
                <div class="ground-input-group" style="margin-bottom: 5px;">
                    <input type="text" name="grounds[]" placeholder="Ground Name 1" required style="width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px;">
                </div>
            </div>
            <button type="button" class="btn-sm btn-secondary" onclick="addGroundInput()" style="margin-top: 5px;">+ Add Ground</button>
        </div>

        <div class="form-group">
            <label for="matches_per_ground">Matches per Ground per Day</label>
            <input type="number" name="matches_per_ground" id="matches_per_ground" value="2" min="1" required>
            <small style="color: #666;">How many games can be played consecutively on one pitch.</small>
        </div>

        <div class="form-row" style="display: flex; gap: 20px;">
            <div class="form-group" style="flex: 1;">
                <label for="start_date">Season Start Date</label>
                <input type="date" name="start_date" id="start_date" required>
            </div>
            <div class="form-group" style="flex: 1;">
                <label for="start_time">Default Kick-off Time</label>
                <input type="time" name="start_time" id="start_time" value="15:00" required>
            </div>
        </div>

        <div class="form-group">
            <label for="gameweek_interval">Interval Between Gameweeks (Days)</label>
            <input type="number" name="gameweek_interval" id="gameweek_interval" value="7" min="1" required>
            <small style="color: #666;">How many days between the start of one gameweek and the next.</small>
        </div>

        <div class="form-group">
            <label for="match_break">Break Between Matches (mins)</label>
            <input type="number" name="match_break" id="match_break" value="15" min="0" required>
            <small style="color: #666;">Time gap between the end of one match and the start of the next on the same ground.</small>
        </div>

        <div class="form-group">
            <label>Match Settings (From System Settings)</label>
            <div class="info-box" style="background: #f9f9f9; padding: 10px; border-radius: 5px; border: 1px solid #ddd;">
                Match Duration: <strong><?php echo $match_duration; ?> mins</strong> | 
                Half-time Break: <strong><?php echo $half_time_break; ?> mins</strong>
            </div>
        </div>

        <button type="submit" class="btn btn-primary" onclick="return confirm('This will generate fixtures for the selected league. Continue?');">Generate Fixtures</button>
    </form>
</div>

<script>
function addGroundInput() {
    const container = document.getElementById('grounds-container');
    const count = container.children.length + 1;
    const div = document.createElement('div');
    div.className = 'ground-input-group';
    div.style.marginBottom = '5px';
    div.innerHTML = `<input type="text" name="grounds[]" placeholder="Ground Name ${count}" required style="width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px;">`;
    container.appendChild(div);
}
</script>

<?php include_once 'includes/footer.php'; ?>
