<?php
// Include bootstrap first to ensure session and config are loaded
require_once dirname(dirname(__DIR__)) . '/core/bootstrap.php';

// Protect all admin pages
$allowed_roles = ['super_admin', 'admin', 'league_manager', 'fixtures_manager', 'super_fantasy_manager', 'finance_manager'];
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['user_role'], $allowed_roles)) {
    header('Location: ../app/login.php');
    exit();
}

$current_user_role = $_SESSION['user_role'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo isset($pageTitle) ? $pageTitle : 'Admin'; ?> - Smart Football</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="stylesheet" href="admin.css">
</head>
<body>

<?php if (defined('DEV_MODE') && DEV_MODE === true && isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'super_admin'): ?>
<div id="dev-user-switcher">
    <form action="/smart_football/dev_switcher.php" method="POST" style="margin-bottom: 8px;">
        <label>Dev: Switch User</label>
        <select name="username" onchange="this.form.submit()">
            <option value="">-- Select User --</option>
            <option value="super_admin_demo" <?php echo ($current_user_role == 'super_admin') ? 'selected' : ''; ?>>Super Admin</option>
            <option value="admin_demo" <?php echo ($current_user_role == 'admin') ? 'selected' : ''; ?>>Admin</option>
            <option value="league_manager_demo" <?php echo ($current_user_role == 'league_manager') ? 'selected' : ''; ?>>League Manager</option>
            <option value="fixtures_manager_demo" <?php echo ($current_user_role == 'fixtures_manager') ? 'selected' : ''; ?>>Fixtures Manager</option>
            <option value="club_manager_demo" <?php echo ($current_user_role == 'club_manager') ? 'selected' : ''; ?>>Club Manager</option>
            <option value="team_manager_demo" <?php echo ($current_user_role == 'team_manager') ? 'selected' : ''; ?>>Team Manager</option>
            <option value="super_fantasy_manager_demo" <?php echo ($current_user_role == 'super_fantasy_manager') ? 'selected' : ''; ?>>Super Fantasy Mgr</option>
            <option value="commissioner_demo" <?php echo ($current_user_role == 'commissioner') ? 'selected' : ''; ?>>Commissioner</option>
            <option value="referee_demo" <?php echo ($current_user_role == 'referee') ? 'selected' : ''; ?>>Referee</option>
            <option value="fan_demo" <?php echo ($current_user_role == 'fan') ? 'selected' : ''; ?>>Fan</option>
            <option value="player_demo" <?php echo ($current_user_role == 'player') ? 'selected' : ''; ?>>Player</option>
            <option value="fantasy_manager_demo" <?php echo ($current_user_role == 'fantasy_manager') ? 'selected' : ''; ?>>Fantasy Manager</option>
        </select>
    </form>
</div>
<style>
    #dev-user-switcher {
        position: fixed;
        bottom: 10px;
        right: 10px;
        z-index: 99999;
        background: #2c3e50;
        padding: 10px;
        border-radius: 8px;
        box-shadow: 0 0 15px rgba(0,0,0,0.3);
        color: white;
        font-family: sans-serif;
        font-size: 12px;
        border: 1px solid #34495e;
    }
    #dev-user-switcher select {
        padding: 5px;
        margin-top: 5px;
        width: 100%;
        background: #fff;
        border: none;
        border-radius: 4px;
    }
    #dev-user-switcher label {
        font-weight: bold;
        display: block;
        margin-bottom: 3px;
        color: #ecf0f1;
    }
    .btn-reset-db {
        width: 100%;
        background: #c0392b;
        color: white;
        border: none;
        padding: 6px;
        border-radius: 4px;
        cursor: pointer;
        font-size: 11px;
        font-weight: bold;
    }
    .btn-reset-db:hover {
        background: #e74c3c;
    }
</style>
<?php endif; ?>