<?php
require_once '../core/bootstrap.php';

$db = new Database();
echo "<h1>Installing Commission System Updates</h1>";

// 1. Update Wallets Table Enum
try {
    // We need to modify the column to include 'site'
    $db->query("ALTER TABLE wallets MODIFY COLUMN entity_type ENUM('user','team','club','board','site') NOT NULL");
    $db->execute();
    echo "Updated 'wallets' table entity_type enum.<br>";
} catch (Exception $e) {
    echo "Error updating wallets table (might already be updated): " . $e->getMessage() . "<br>";
}

// 2. Add Commission Settings
$settings_to_add = [
    'site_commission_percent' => '5',
    'board_commission_percent' => '10'
];

foreach ($settings_to_add as $key => $val) {
    $db->query("SELECT setting_key FROM settings WHERE setting_key = :key");
    $db->bind(':key', $key);
    if (!$db->single()) {
        $db->query("INSERT INTO settings (setting_key, setting_value) VALUES (:key, :val)");
        $db->bind(':key', $key);
        $db->bind(':val', $val);
        $db->execute();
        echo "Added setting: $key<br>";
    }
}

echo "<br><strong>Installation Complete.</strong>";
?>