<?php
require_once '../core/bootstrap.php';

// --- Security Check ---
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['user_role'], ['super_admin', 'admin'])) {
    die('Access Denied.');
}

$db = new Database();
echo "<h1>Updating Users Table...</h1>";

try {
    $db->query("ALTER TABLE `users` ADD `status` ENUM('active','banned') NOT NULL DEFAULT 'active' AFTER `role`");
    $db->execute();
    echo "Success: Added 'status' column to users table.<br>";
} catch (Exception $e) {
    echo "Info: 'status' column likely already exists.<br>";
}

try {
    $db->query("ALTER TABLE `users` ADD `ban_reason` TEXT NULL DEFAULT NULL AFTER `status`");
    $db->execute();
    echo "Success: Added 'ban_reason' column to users table.<br>";
} catch (Exception $e) {
    echo "Info: 'ban_reason' column likely already exists.<br>";
}

echo "<br><strong>Database update complete. You can delete this file now.</strong>";
?>