<?php
$pageTitle = 'Manage Announcements';
include_once 'includes/header.php';

$announcementModel = new Announcement();

// Handle Actions
if (isset($_GET['delete_id'])) {
    $announcementModel->delete($_GET['delete_id']);
    header('Location: manage_announcements.php?status=deleted');
    exit();
}
if (isset($_GET['toggle_id'])) {
    $announcementModel->toggleStatus($_GET['toggle_id']);
    header('Location: manage_announcements.php?status=updated');
    exit();
}

$announcements = $announcementModel->getAll();

include_once 'includes/sidebar.php';
?>

<h1>Manage Announcements</h1>
<a href="add_announcement.php" class="btn btn-add">Post New Announcement</a>

<div class="table-wrapper">
    <table class="styled-table">
        <thead>
            <tr>
                <th>Date</th>
                <th>Title</th>
                <th>Type</th>
                <th>Author</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($announcements as $item): ?>
            <tr>
                <td><?php echo date('d M Y', strtotime($item->created_at)); ?></td>
                <td><?php echo htmlspecialchars($item->title); ?></td>
                <td><span class="status-badge status-<?php echo $item->type; ?>"><?php echo ucfirst($item->type); ?></span></td>
                <td><?php echo htmlspecialchars($item->first_name . ' ' . $item->last_name); ?></td>
                <td>
                    <a href="?toggle_id=<?php echo $item->id; ?>" class="status-badge status-<?php echo $item->is_active ? 'active' : 'inactive'; ?>">
                        <?php echo $item->is_active ? 'Active' : 'Hidden'; ?>
                    </a>
                </td>
                <td class="actions-cell">
                    <a href="?delete_id=<?php echo $item->id; ?>" class="btn-sm btn-delete" onclick="return confirm('Delete this announcement?');">Delete</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<style>
.status-news { background: #e3f2fd; color: #0d47a1; }
.status-alert { background: #fce4ec; color: #c62828; }
.status-info { background: #e8f5e9; color: #1b5e20; }
</style>

<?php include_once 'includes/footer.php'; ?>
