<?php
$pageTitle = 'Manage Clubs';
include_once 'includes/header.php';
$clubModel = new Club();
$message = '';
$error = '';

// Handle deletion
if (isset($_GET['delete_id'])) {
    $delete_id = filter_input(INPUT_GET, 'delete_id', FILTER_VALIDATE_INT);
    if ($delete_id && $clubModel->delete($delete_id)) {
        $_SESSION['flash_message'] = 'Club deleted successfully!';
        header('Location: manage_clubs.php');
        exit();
    } else {
        $_SESSION['flash_error'] = 'Failed to delete club. It might be associated with teams or fixtures.';
        header('Location: manage_clubs.php');
        exit();
    }
}

// Check for flash messages from redirects
if (isset($_SESSION['flash_message'])) {
    $message = $_SESSION['flash_message'];
    unset($_SESSION['flash_message']);
}
if (isset($_SESSION['flash_error'])) {
    $error = $_SESSION['flash_error'];
    unset($_SESSION['flash_error']);
}

$clubs = $clubModel->getAllForAdmin();

include_once 'includes/sidebar.php';
?>
<h1>Manage Clubs</h1>
<a href="add_club.php" class="btn btn-add">Add New Club</a>

<!-- Display Messages -->
<?php if ($message): ?>
    <div class="message success"><?php echo $message; ?></div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="message error"><?php echo $error; ?></div>
<?php endif; ?>

<div class="table-wrapper">
    <table class="styled-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Logo</th>
                <th>Name</th>
                <th>Stadium</th>
                <th>League</th>
                <th>Manager</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($clubs)): ?>
                <tr><td colspan="7">No clubs found. You can add one using the button above.</td></tr>
            <?php endif; ?>
            <?php foreach ($clubs as $club): ?>
            <tr>
                <td><?php echo htmlspecialchars($club->id); ?></td>
                <td>
                    <?php if (!empty($club->logo)): ?><img src="<?php echo htmlspecialchars($club->logo); ?>" alt="<?php echo htmlspecialchars($club->name); ?> Logo" style="width: 40px; height: 40px; object-fit: contain;"><?php endif; ?>
                </td>
                <td><?php echo htmlspecialchars($club->name); ?></td>
                <td><?php echo htmlspecialchars($club->stadium); ?></td>
                <td><?php echo htmlspecialchars($club->league_name ?? 'N/A'); ?></td>
                <td><?php echo htmlspecialchars($club->manager_name ?? 'N/A'); ?></td>
                <td class="actions-cell">
                    <a href="edit_club.php?id=<?php echo $club->id; ?>" class="btn-sm btn-edit">Edit</a>
                    <a href="?delete_id=<?php echo $club->id; ?>" class="btn-sm btn-delete" onclick="return confirm('Are you sure you want to delete this club?');">Delete</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include_once 'includes/footer.php'; ?>