<?php
require_once '../core/bootstrap.php';

// Auth check
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['admin_user_role'] ?? '', ['admin', 'super_admin'])) {
    header('Location: dashboard.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $campaign_id = filter_input(INPUT_POST, 'campaign_id', FILTER_VALIDATE_INT);
    $action = $_POST['action'] ?? '';

    if ($campaign_id && in_array($action, ['approve', 'reject'])) {
        $sponsorModel = new Sponsorship();
        $notificationModel = new Notification();
        
        $campaign = $sponsorModel->getCampaignById($campaign_id);
        $status = ($action === 'approve') ? 'active' : 'rejected';
        
        if ($sponsorModel->updateCampaignStatus($campaign_id, $status)) {
            $_SESSION['flash_message'] = "Campaign #{$campaign_id} has been " . ucfirst($status) . ".";
            
            if ($campaign) {
                $msg = "Your campaign (ID: #{$campaign_id}) has been " . ucfirst($status) . ".";
                $notificationModel->create($campaign->user_id, 'campaign_status', $msg);
            }
        } else {
            $_SESSION['flash_error'] = "Failed to update campaign status.";
        }
    }
}

header('Location: sponsor_campaigns.php');
exit();