<?php
$pageTitle = 'Sponsorship Packages';
include_once 'includes/header.php';

if (!in_array($_SESSION['admin_user_role'] ?? '', ['admin', 'super_admin'])) {
    header('Location: dashboard.php');
    exit();
}

$sponsorModel = new Sponsorship();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = [
        'name' => $_POST['name'],
        'type' => $_POST['type'],
        'price' => $_POST['price'],
        'duration_days' => $_POST['duration_days'],
        'description' => $_POST['description'],
        'is_active' => isset($_POST['is_active']) ? 1 : 0
    ];
    if ($sponsorModel->createPackage($data)) {
        $_SESSION['flash_message'] = 'Package created successfully.';
    } else {
        $_SESSION['flash_error'] = 'Failed to create package.';
    }
    header('Location: sponsorship_packages.php');
    exit();
}

$packages = $sponsorModel->getAllPackages();
include_once 'includes/sidebar.php';
?>

<h1>Sponsorship Packages</h1>

<?php if (isset($_SESSION['flash_message'])): ?><div class="message success"><?php echo $_SESSION['flash_message']; unset($_SESSION['flash_message']); ?></div><?php endif; ?>

<div class="dashboard-section">
    <h3>Create New Package</h3>
    <form action="" method="POST" class="styled-form">
        <div class="form-group">
            <label>Package Name</label>
            <input type="text" name="name" required placeholder="e.g. Premier League Title Sponsor">
        </div>
        <div class="form-group">
            <label>Type</label>
            <select name="type" required>
                <option value="league">League Sponsor (Exclusive)</option>
                <option value="match">Match Day Sponsor</option>
                <option value="fixture_list">Fixtures Sponsor</option>
                <option value="ad">General Ad Campaign</option>
            </select>
        </div>
        <div class="form-group">
            <label>Price ($)</label>
            <input type="number" name="price" step="0.01" required>
        </div>
        <div class="form-group">
            <label>Duration (Days)</label>
            <input type="number" name="duration_days" required placeholder="e.g. 30 for 1 month, 1 for match day">
        </div>
        <div class="form-group">
            <label>Description</label>
            <textarea name="description" rows="3"></textarea>
        </div>
        <div class="form-group">
            <label><input type="checkbox" name="is_active" checked> Active</label>
        </div>
        <button type="submit" class="btn">Create Package</button>
    </form>
</div>

<div class="dashboard-section">
    <h3>Existing Packages</h3>
    <table class="styled-table">
        <thead><tr><th>Name</th><th>Type</th><th>Price</th><th>Duration</th><th>Status</th></tr></thead>
        <tbody>
            <?php foreach ($packages as $p): ?>
                <tr>
                    <td><?php echo htmlspecialchars($p->name); ?></td>
                    <td><?php echo ucfirst($p->type); ?></td>
                    <td>$<?php echo number_format($p->price, 2); ?></td>
                    <td><?php echo $p->duration_days; ?> Days</td>
                    <td><?php echo $p->is_active ? 'Active' : 'Inactive'; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
<?php include_once 'includes/footer.php'; ?>