<?php
$pageTitle = 'Wallet Management';
include_once 'includes/header.php';

// --- Auth Check ---
$allowed_roles = ['admin', 'super_admin', 'finance_manager'];
$current_role = $_SESSION['user_role'] ?? $_SESSION['admin_user_role'] ?? '';
if (!in_array($current_role, $allowed_roles)) {
    header('Location: dashboard.php');
    exit();
}

$walletModel = new Wallet();
$settingModel = new Setting();
$wallets = $walletModel->getAllWalletsWithDetails();

// Get currency symbol
$settings = $settingModel->getAll();
$currency_symbol = ($settings['system_currency'] ?? 'USD') === 'ZMW' ? 'K' : '$';

include_once 'includes/sidebar.php';
?>

<h1>Wallet Management</h1>

<?php if (isset($_SESSION['flash_message'])): ?>
    <div class="message success"><?php echo $_SESSION['flash_message']; unset($_SESSION['flash_message']); ?></div>
<?php endif; ?>
<?php if (isset($_SESSION['flash_error'])): ?>
    <div class="message error"><?php echo $_SESSION['flash_error']; unset($_SESSION['flash_error']); ?></div>
<?php endif; ?>

<div class="dashboard-section">
    <h2>Manual Wallet Top-Up</h2>
    <div class="form-container">
        <form action="manual_finance_process.php" method="POST">
            <input type="hidden" name="action" value="manual_topup">
            <div class="form-group">
                <label for="wallet_id">Select Wallet</label>
                <select name="wallet_id" id="wallet_id" required>
                    <option value="">-- Select a Wallet --</option>
                    <?php foreach ($wallets as $wallet): ?>
                        <option value="<?php echo $wallet->id; ?>">
                            <?php echo ucfirst($wallet->entity_type) . ': ' . htmlspecialchars($wallet->entity_name) . ' (Balance: ' . $currency_symbol . number_format($wallet->balance, 2) . ')'; ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="form-group">
                <label for="amount">Amount to Add</label>
                <input type="number" name="amount" id="amount" step="0.01" min="0.01" required>
            </div>
            <div class="form-group">
                <label for="description">Description</label>
                <input type="text" name="description" id="description" required placeholder="e.g., Manual adjustment, Bonus, etc.">
            </div>
            <button type="submit" class="btn">Top Up Wallet</button>
        </form>
    </div>
</div>

<div class="dashboard-section">
    <h2>All Wallets</h2>
    <div class="table-wrapper">
        <table class="styled-table">
            <thead>
                <tr>
                    <th>Wallet ID</th>
                    <th>Entity</th>
                    <th>Balance</th>
                    <th>Actions</th>
                    <th>Last Updated</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($wallets as $wallet): ?>
                    <tr>
                        <td><?php echo $wallet->id; ?></td>
                        <td><?php echo ucfirst($wallet->entity_type) . ' - ' . htmlspecialchars($wallet->entity_name); ?></td>
                        <td><?php echo $currency_symbol; ?><?php echo number_format($wallet->balance, 2); ?></td>
                        <td>
                            <a href="wallet_transactions.php?wallet_id=<?php echo $wallet->id; ?>" class="btn-sm">View Log</a>
                        </td>
                        <td><?php echo date('d M Y, H:i', strtotime($wallet->updated_at)); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include_once 'includes/footer.php'; ?>