<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers,Content-Type,Access-Control-Allow-Methods, Authorization, X-Requested-With');

require_once '../../../core/bootstrap.php';

$user = new User();
$user_id = $user->getUserIdFromToken();
if (!$user_id) {
    http_response_code(401);
    echo json_encode(['message' => 'Unauthorized']);
    exit();
}

$season = filter_input(INPUT_GET, 'season', FILTER_SANITIZE_STRING);

$fantasyTeamModel = new FantasyTeam();
$team = $fantasyTeamModel->findByUserAndSeason($user_id, $season);

if (!$team) {
    http_response_code(404);
    echo json_encode(['message' => 'No fantasy team found for this user and season.']);
    exit();
}

http_response_code(200);
echo json_encode(['team' => $team]);
?>