<?php
// Set headers for JSON response
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header('Access-Control-Allow-Methods: GET');

// Bootstrap the application
require_once '../../../core/bootstrap.php';

// Instantiate Fixture model
$fixture = new Fixture();

// Get the league ID and optional gameweek from the URL query string
$league_id = filter_input(INPUT_GET, 'league_id', FILTER_VALIDATE_INT);
$gameweek = filter_input(INPUT_GET, 'gameweek', FILTER_VALIDATE_INT);

if (!$league_id) {
    http_response_code(400); // Bad Request
    echo json_encode(['message' => 'A valid integer league_id is required.']);
    exit();
}

// Pass gameweek to the model method. If it's null, the model will ignore it.
$fixtures = $fixture->getAllByLeague($league_id, $gameweek);

echo json_encode($fixtures);
?>