<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

require_once '../../../core/bootstrap.php';

$fixtureModel = new Fixture();

$fixture_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

if (!$fixture_id) {
    http_response_code(400);
    echo json_encode(['message' => 'A valid fixture ID is required.']);
    exit();
}

try {
    // Using a method that joins team names and logos
    $fixture = $fixtureModel->getAllByLeague(null, null, $fixture_id);

    if (empty($fixture)) {
        http_response_code(404);
        echo json_encode(['message' => 'Fixture not found.']);
        exit();
    }
    http_response_code(200);
    // Since we are fetching by ID, we expect a single result.
    echo json_encode($fixture[0]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['message' => 'An error occurred while fetching the fixture.']);
}
?>