<?php
// Set headers for JSON response
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header('Access-Control-Allow-Methods: GET');

// Bootstrap the application
require_once '../../../core/bootstrap.php';

// Instantiate League model
$league = new League();

// Get the league ID from the URL query string and validate it
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

if (!$id) {
    http_response_code(400); // Bad Request
    echo json_encode(['message' => 'A valid integer league ID is required.']);
    exit();
}

// Fetch the league from the database
$result = $league->getById($id);

if ($result) {
    http_response_code(200); // OK
    echo json_encode($result);
} else {
    http_response_code(404); // Not Found
    echo json_encode(['message' => 'League not found.']);
}
?>