<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
require_once '../../../core/bootstrap.php';

$league_id = filter_input(INPUT_GET, 'league_id', FILTER_VALIDATE_INT);
$type = filter_input(INPUT_GET, 'type', FILTER_SANITIZE_STRING) ?? 'full';

if (!$league_id) {
    http_response_code(400);
    echo json_encode(['message' => 'A valid integer league_id is required.']);
    exit();
}

$leagueModel = new League();
$fixtureModel = new Fixture();

$league = $leagueModel->getById($league_id);
if (!$league) {
    http_response_code(404);
    echo json_encode(['message' => 'League not found.']);
    exit();
}

$tableData = $leagueModel->getTable($league_id, $type);

http_response_code(200);
echo json_encode($tableData);
?>