<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
require_once '../../../core/bootstrap.php';

$player_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

if (!$player_id) {
    http_response_code(400);
    echo json_encode(['message' => 'A valid integer player ID is required.']);
    exit();
}

$playerModel = new Player();
$user = new User();
$current_user_id = $user->getUserIdFromToken();

$player_data = $playerModel->getPlayerDetails($player_id, $current_user_id);

if (!$player_data || !$player_data->id) { // Check if a valid player was returned
    http_response_code(404);
    echo json_encode(['message' => 'Player not found.']);
    exit();
}

http_response_code(200);
echo json_encode($player_data);
?>