<?php
// Set headers for JSON response
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header('Access-Control-Allow-Methods: GET');

// Bootstrap the application
require_once '../../../core/bootstrap.php';

// Instantiate models
$player = new Player();
$user = new User();

// Get the player ID from the URL query string and validate it
$player_id = filter_input(INPUT_GET, 'player_id', FILTER_VALIDATE_INT);

if (!$player_id) {
    http_response_code(400); // Bad Request
    echo json_encode(['message' => 'A valid integer player_id is required.']);
    exit();
}

// 1. Check if the user exists
$playerInfo = $user->findById($player_id);
if (!$playerInfo || $playerInfo->role !== 'player') {
    http_response_code(404);
    echo json_encode(['message' => 'Player not found.']);
    exit();
}

// 2. Get the player's stats
$playerStats = $player->getStats($player_id);

// 3. Combine the information into a single response
$response = [
    'player_info' => [
        'id' => (int)$playerInfo->id,
        'username' => $playerInfo->username
    ],
    'stats' => $playerStats
];

http_response_code(200); // OK
echo json_encode($response);
?>