<?php
// Set headers for JSON response
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header('Access-Control-Allow-Methods: GET');

// Bootstrap the application
require_once '../../../core/bootstrap.php';

// Instantiate models
$playerModel = new Player();
$clubModel = new Club();
$leagueModel = new League();

// Get search query from URL
$query = filter_input(INPUT_GET, 'query', FILTER_SANITIZE_STRING);

if (empty($query)) {
    http_response_code(400);
    echo json_encode(['message' => 'Search query is required.']);
    exit();
}

// Perform searches
$players = $playerModel->searchByName($query);
$clubs = $clubModel->searchByName($query);
$leagues = $leagueModel->searchByName($query);

http_response_code(200);
echo json_encode([
    'players' => $players,
    'clubs' => $clubs,
    'leagues' => $leagues
]);
?>