<?php
// Set headers for JSON response
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header('Access-Control-Allow-Methods: GET');

// Bootstrap the application
require_once '../../../core/bootstrap.php';

// Instantiate Player model
$player = new Player();

// Get the team ID from the URL query string and validate it
$team_id = filter_input(INPUT_GET, 'team_id', FILTER_VALIDATE_INT);

if (!$team_id) {
    http_response_code(400); // Bad Request
    echo json_encode(['message' => 'A valid integer team_id is required.']);
    exit();
}

// Fetch the players from the database using the existing method in the Player model
$players = $player->getAllByTeam($team_id);

http_response_code(200); // OK
echo json_encode($players);
?>