<?php
require_once '../../core/bootstrap.php';

header('Content-Type: application/json');

$player_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$season = $_GET['season'] ?? null; // Optional season filter

if (!$player_id) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid player ID']);
    exit();
}

$playerModel = new Player();
$statModel = new Stat();

$player_details = $playerModel->getPlayerDetailsById($player_id);
$player_stats = $statModel->getStatsForPlayer($player_id, $season);

if (!$player_details || !$player_stats) {
    http_response_code(404);
    echo json_encode(['error' => 'Player data not found']);
    exit();
}

// Combine details and stats into one object
$response_data = (object) array_merge((array)$player_details, (array)$player_stats);

echo json_encode($response_data);