<?php
header('Content-Type: application/json');
require_once '../../core/bootstrap.php';

// --- Authentication and Role Check ---
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'team_manager') {
    http_response_code(403);
    echo json_encode(['error' => 'Access Denied']);
    exit();
}

$team_id = filter_input(INPUT_GET, 'team_id', FILTER_VALIDATE_INT);
if (!$team_id) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid Team ID']);
    exit();
}

$playerModel = new Player();

try {
    $injured_players = $playerModel->getInjuredPlayersByTeamId($team_id);
} catch (Exception $e) {
    $injured_players = [];
}

try {
    $suspended_players = $playerModel->getSuspendedPlayersByTeamId($team_id);
} catch (Exception $e) {
    $suspended_players = [];
}

echo json_encode([
    'injured' => $injured_players,
    'suspended' => $suspended_players
]);
?>