<?php
require_once '../../core/bootstrap.php';

header('Content-Type: application/json');

$query = $_GET['q'] ?? '';

if (strlen($query) < 2) {
    echo json_encode(['players' => [], 'teams' => []]);
    exit();
}

$playerModel = new Player();
$teamModel = new Team();

// Use existing search methods. We can limit results in the future if needed.
$players = $playerModel->searchPlayers($query);
$teams = $teamModel->searchTeams($query);

// Slice arrays to limit results for performance
$players = array_slice($players, 0, 5);
$teams = array_slice($teams, 0, 5);

echo json_encode(['players' => $players, 'teams' => $teams]);
?>