<?php
require_once '../../core/bootstrap.php';

header('Content-Type: application/json');

$query = $_GET['q'] ?? '';

if (strlen($query) < 2) {
    echo json_encode([]);
    exit;
}

$playerModel = new Player();
$players = $playerModel->searchPlayers($query);

$results = [];
if ($players) {
    foreach ($players as $player) {
        $results[] = [
            'id' => $player->id,
            'first_name' => $player->first_name,
            'last_name' => $player->last_name,
            'club_name' => $player->club_name ?? 'Free Agent',
            'club_logo' => $player->club_logo,
            'position' => $player->position ?? 'Unknown',
            'image' => $player->profile_picture
        ];
    }
}

echo json_encode($results);