<?php
// Set the correct header to tell the browser this is a CSS file.
header('Content-Type: text/css');

// We need to go up three directories from /app/assets/css/ to reach the root /core/ folder.
require_once dirname(__DIR__, 3) . '/core/bootstrap.php';

// Fetch application-wide settings
$settingModel = new Setting();
$settings = $settingModel->getAll();

// Set default fallback colors in case they are not in the database
$primaryColor = $settings['primary_color'] ?? '#2c3e50';
$secondaryColor = $settings['secondary_color'] ?? '#3498db';

// Start outputting the CSS. We use CSS Custom Properties for maximum flexibility.
?>
:root {
    --primary-color: <?php echo htmlspecialchars($primaryColor); ?>;
    --secondary-color: <?php echo htmlspecialchars($secondaryColor); ?>;

    /* You can create other theme variables based on the primary ones */
    --header-bg: var(--primary-color);
    --header-text-color: #ffffff;
    --link-color: var(--secondary-color);
    --link-hover-color: var(--primary-color);
    --button-bg-color: var(--secondary-color);
}