<?php
$pageTitle = 'Assigned Matches';
include 'includes/header.php';

// --- Authentication and Role Check ---
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'commissioner') {
    // Redirect users who are not logged-in commissioners
    header('Location: login.php');
    exit();
}
$commissioner_id = $_SESSION['user_id'];

// --- Instantiate Models and Fetch Data ---
$fixtureModel = new Fixture();
$matches = $fixtureModel->getAllByCommissioner($commissioner_id);

?>

<div class="page-content">
    <div class="matches-header">
        <h1>Assigned Matches</h1>
    </div>

    <div class="dashboard-section">
        <h2 class="dashboard-title">Your Upcoming & Past Assignments</h2>
        <div class="fixture-list">
            <?php if (!empty($matches)): ?>
                <?php foreach ($matches as $match): ?>
                    <a href="live_scorer.php?fixture_id=<?php echo $match->id; ?>" class="fixture-item">
                        <div class="team home-team"><?php echo htmlspecialchars($match->home_team_name); ?></div>
                        <?php if ($match->status === 'finished'): ?>
                            <div class="score-box"><?php echo $match->home_team_score; ?> - <?php echo $match->away_team_score; ?></div>
                        <?php else: ?>
                            <div class="score-box time-box">
                                <span class="time"><?php echo date('H:i', strtotime($match->match_datetime)); ?></span>
                                <span class="date"><?php echo date('d M Y', strtotime($match->match_datetime)); ?></span>
                            </div>
                        <?php endif; ?>
                        <div class="team away-team"><?php echo htmlspecialchars($match->away_team_name); ?></div>
                    </a>
                <?php endforeach; ?>
            <?php else: ?>
                <p class="no-data-msg">You have not been assigned to any matches yet.</p>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php
include 'includes/footer.php';
?>