<?php
$is_logged_in = isset($_SESSION['user_id']);
$current_user_role = $_SESSION['user_role'] ?? 'guest';
?>
<ul>
    <?php // --- Admin Dashboard Link --- ?>
    <?php if (in_array($current_user_role, ['super_admin', 'admin', 'league_manager', 'finance_manager', 'super_fantasy_manager', 'fixtures_manager'])): ?>
        <li><a href="<?php echo URL_ROOT; ?>/admin/dashboard.php" style="font-weight: bold; color: var(--primary-color);">Admin Dashboard</a></li>
    <?php endif; ?>

    <li><a href="<?php echo URL_ROOT; ?>/app/profile.php">My Profile</a></li>

    <?php // --- Role-Specific Menu Items --- ?>
    <?php switch ($current_user_role):
        case 'player': ?>
            <li><a href="<?php echo URL_ROOT; ?>/app/player_stats.php">My Stats</a></li>
            <li><a href="<?php echo URL_ROOT; ?>/app/team_hub.php">Team Hub</a></li>
            <?php break; ?>

        <?php case 'club_manager': ?>
            <li><a href="<?php echo URL_ROOT; ?>/app/my_club.php">My Club</a></li>
            <li><a href="<?php echo URL_ROOT; ?>/app/staff_members.php">Staff Members</a></li>
            <li><a href="<?php echo URL_ROOT; ?>/app/club_finances.php">Club Finances</a></li>
            <li><a href="<?php echo URL_ROOT; ?>/app/teams.php">Teams</a></li>
            <li><a href="<?php echo URL_ROOT; ?>/app/club_members.php">Club Members</a></li>
            <?php break; ?>

        <?php case 'team_manager': ?>
            <li><a href="<?php echo URL_ROOT; ?>/app/my_team.php">My Team</a></li>
            <li><a href="<?php echo URL_ROOT; ?>/app/select_fixture_lineup.php">Submit Lineup</a></li>
            <li><a href="<?php echo URL_ROOT; ?>/app/suspended_players.php">Suspended Players</a></li>
            <li><a href="<?php echo URL_ROOT; ?>/app/injury_list.php">Injury List</a></li>
            <li><a href="<?php echo URL_ROOT; ?>/app/training_attendance.php">Training Attendance</a></li>
            <?php break; ?>

        <?php case 'referee': ?>
            <li><a href="<?php echo URL_ROOT; ?>/app/referee_matches.php">My Matches</a></li>
            <?php break; ?>

        <?php case 'commissioner': ?>
            <li><a href="<?php echo URL_ROOT; ?>/app/commissioner_matches.php">Assigned Matches</a></li>
            <li><a href="<?php echo URL_ROOT; ?>/app/live_scorer.php">Live Scorer</a></li>
            <?php break; ?>

        <?php default: // 'user' or 'fan' role ?>
            <li><a href="<?php echo URL_ROOT; ?>/app/fantasy.php">My Fantasy Team</a></li>
            <?php break; ?>
    <?php endswitch; ?>

    <li><a href="<?php echo URL_ROOT; ?>/app/memberships.php">Memberships</a></li>
    <li><a href="<?php echo URL_ROOT; ?>/app/sponsor_dashboard.php">Advertise</a></li>

    <?php // --- Dev Switcher ---
    $is_localhost = in_array($_SERVER['REMOTE_ADDR'], ['127.0.0.1', '::1']);
    $is_super_admin = ($current_user_role === 'super_admin');
    if (($is_localhost || $is_super_admin) && file_exists('dev_switcher.php')):
    ?>
        <li style="margin-top: 10px; border-top: 1px solid var(--border-color); padding-top: 10px;">
            <?php include 'dev_switcher.php'; ?>
        </li>
    <?php endif; ?>

    <li><a href="<?php echo URL_ROOT; ?>/app/logout.php">Logout</a></li>
</ul>