<tr>
    <td><?php echo htmlspecialchars($camp->package_name); ?></td>
    <td>
        <?php 
        if ($camp->package_type == 'league') echo "League ID: " . $camp->entity_id;
        elseif ($camp->package_type == 'match') echo "Match ID: " . $camp->entity_id;
        else echo "General";
        ?>
    </td>
    <td><span class="status-badge status-<?php echo $camp->status; ?>"><?php echo ucfirst($camp->status); ?></span></td>
    <td><?php echo date('d M Y', strtotime($camp->end_date)); ?></td>
    <td><strong><?php echo number_format($camp->views ?? 0); ?></strong></td>
    <td><?php echo number_format($camp->clicks ?? 0); ?></td>
    <td>
        <?php 
            $ctr = ($camp->views > 0) ? ($camp->clicks / $camp->views) * 100 : 0;
            echo number_format($ctr, 2) . '%';
        ?>
    </td>
    <td>
        <?php if (in_array($camp->status, ['active', 'pending', 'paused'])): ?>
            <button class="btn-sm btn-edit" onclick='openEditModal(<?php echo json_encode($camp); ?>)'>Edit</button>
        <?php endif; ?>

        <?php if ($camp->status === 'active'): ?>
            <form action="sponsor_campaign_process.php" method="POST" style="display:inline;">
                <input type="hidden" name="action" value="pause">
                <input type="hidden" name="campaign_id" value="<?php echo $camp->id; ?>">
                <button type="submit" class="btn-sm" style="background-color: #f39c12; border: none; color: white; cursor: pointer; padding: 5px 10px; border-radius: 4px;">Pause</button>
            </form>
            <button class="btn-sm" onclick='openExtendModal(<?php echo json_encode($camp); ?>)' style="background-color: #3498db; border: none; color: white; cursor: pointer; padding: 5px 10px; border-radius: 4px; margin-left: 5px;">Extend</button>
        <?php elseif ($camp->status === 'paused'): ?>
            <form action="sponsor_campaign_process.php" method="POST" style="display:inline;">
                <input type="hidden" name="action" value="resume">
                <input type="hidden" name="campaign_id" value="<?php echo $camp->id; ?>">
                <button type="submit" class="btn-sm" style="background-color: #2ecc71; border: none; color: white; cursor: pointer; padding: 5px 10px; border-radius: 4px;">Resume</button>
            </form>
        <?php endif; ?>
    </td>
</tr>