<?php
// This is a partial view for a single notification item.
// It expects a $notif object to be available in its scope.

// Determine Icon based on type
$icon = '<i class="fa-solid fa-circle-info" style="color: #3498db;"></i>';
if ($notif->type === 'withdrawal_status') {
    $icon = '<i class="fa-solid fa-money-bill-transfer" style="color: #2ecc71;"></i>';
} elseif ($notif->type === 'fine_paid') {
    $icon = '<i class="fa-solid fa-receipt" style="color: #f1c40f;"></i>';
} elseif ($notif->type === 'roster_update') {
    $icon = '<i class="fa-solid fa-users" style="color: #9b59b6;"></i>';
} elseif ($notif->type === 'fee_reminder') {
    $icon = '<i class="fa-solid fa-bell" style="color: #e74c3c;"></i>';
}
?>
<div class="notification-item unread" data-id="<?php echo $notif->id; ?>">
    <div style="display: flex; gap: 15px; align-items: flex-start;">
        <div style="font-size: 1.2rem; margin-top: 2px; color: #888;"><?php echo $icon; ?></div>
        <div>
            <?php echo strip_tags($notif->message, '<a><strong>'); ?>
            <div style="font-size: 0.75rem; color: #888; margin-top: 4px;"><?php echo date('M d, H:i', strtotime($notif->created_at)); ?></div>
        </div>
    </div>
</div>