<?php
require_once '../core/bootstrap.php';

// --- Authentication and Role Check ---
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'team_manager') {
    header('Location: login.php');
    exit();
}

$pageTitle = 'Injury List';
include 'includes/header.php';

$manager_id = $_SESSION['user_id'];

// --- Instantiate Models and Fetch Data ---
$teamModel = new Team();
$playerModel = new Player();

// Get the manager's team
$team = $teamModel->getTeamByManagerId($manager_id);

$injured_players = [];
$injury_history = [];
if ($team) {
    // Get the currently injured players on the team
    try {
        $injured_players = $playerModel->getInjuredPlayersByTeamId($team->id);
        $injury_history = $playerModel->getInjuryHistoryByTeamId($team->id);
    } catch (PDOException $e) {
        // Gracefully handle if 'injuries' table doesn't exist yet
        $injured_players = [];
        $injury_history = [];
    }
}

?>

<div class="page-content">
    <div class="matches-header">
        <div class="header-content">
            <h1>Injury List</h1>
            <p>Track and manage player fitness and recovery.</p>
        </div>
        <a href="/smart_football/app/add_injury.php" class="btn"><i class="fa-solid fa-plus"></i> Add Injury</a>
    </div>

    <?php if ($team): ?>
        <div class="dashboard-section">
            <h2 class="dashboard-title">Active Injuries</h2>
            <?php if (!empty($injured_players)): ?>
                <div class="table-wrapper">
                    <table class="styled-table">
                        <thead><tr><th>Player</th><th>Injury</th><th>Date Injured</th><th>Expected Return</th><th>Actions</th></tr></thead>
                        <tbody>
                            <?php foreach ($injured_players as $player): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($player->first_name . ' ' . $player->last_name); ?></td>
                                    <td><?php echo htmlspecialchars($player->injury_description); ?></td>
                                    <td><?php echo date('d M Y', strtotime($player->start_date)); ?></td>
                                    <td><?php echo $player->expected_return_date ? date('d M Y', strtotime($player->expected_return_date)) : 'N/A'; ?></td>
                                    <td><a href="/smart_football/app/edit_injury.php?id=<?php echo $player->injury_id; ?>" class="btn-sm btn-edit"><i class="fa-solid fa-pen"></i> Edit</a></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <p class="no-data-msg">No players are currently on the injury list.</p>
            <?php endif; ?>
        </div>

        <div class="dashboard-section">
            <h2 class="dashboard-title">Injury History</h2>
            <?php if (!empty($injury_history)): ?>
                <div class="table-wrapper">
                    <table class="styled-table">
                        <thead><tr><th>Player</th><th>Injury</th><th>Date Injured</th><th>Date Recovered</th><th>Status</th></tr></thead>
                        <tbody>
                            <?php foreach ($injury_history as $record): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($record->first_name . ' ' . $record->last_name); ?></td>
                                    <td><?php echo htmlspecialchars($record->injury_description); ?></td>
                                    <td><?php echo date('d M Y', strtotime($record->start_date)); ?></td>
                                    <td><?php echo $record->expected_return_date ? date('d M Y', strtotime($record->expected_return_date)) : 'N/A'; ?></td>
                                    <td><span class="status-badge status-available">Recovered</span></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <p class="no-data-msg">No historical injury records found.</p>
            <?php endif; ?>
        </div>
    <?php else: ?>
        <p class="no-data-msg">You are not currently assigned as a manager to any team.</p>
    <?php endif; ?>
</div>

<style>
.matches-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
}
</style>

<?php include 'includes/footer.php'; ?>