<?php
require_once '../core/bootstrap.php';

if (isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit();
}

$pageTitle = 'Sign Up';
include 'includes/header.php';
?>

<div class="page-content auth-page">
    <div class="auth-wrapper">
        <div class="auth-container" style="max-width: 500px;">
            <div class="auth-header">
                <img src="<?php echo htmlspecialchars($appLogo); ?>" alt="<?php echo htmlspecialchars($appName); ?> Logo" class="auth-logo">
                <h1>Create Account</h1>
                <p>Join the community today.</p>
            </div>

            <?php if (isset($_GET['error'])): ?>
                <div class="error-message"><i class="fa-solid fa-circle-exclamation"></i> <?php echo htmlspecialchars($_GET['error']); ?></div>
            <?php endif; ?>

            <form action="register_process.php" method="POST" enctype="multipart/form-data" class="auth-form">
                <div class="form-row" style="display: flex; gap: 15px;">
                    <div class="form-group" style="flex: 1;">
                        <label for="first_name">First & Middle Name</label>
                        <input type="text" id="first_name" name="first_name" placeholder="e.g. John James" required>
                    </div>
                    <div class="form-group" style="flex: 1;">
                        <label for="last_name">Surname</label>
                        <input type="text" id="last_name" name="last_name" placeholder="e.g. Doe" required>
                    </div>
                </div>

                <div class="form-group">
                    <label for="username">Username</label>
                    <input type="text" id="username" name="username" placeholder="johndoe123" required>
                </div>

                <div class="form-group">
                    <label for="email">Email Address</label>
                    <input type="email" id="email" name="email" placeholder="you@example.com" required>
                </div>

                <div class="form-group">
                    <label for="phone_number">Phone Number</label>
                    <input type="tel" id="phone_number" name="phone_number" placeholder="+1234567890">
                </div>

                <div class="form-group">
                    <label for="password">Password</label>
                    <input type="password" id="password" name="password" placeholder="••••••••" required minlength="6">
                </div>

                <div class="form-group">
                    <label for="confirm_password">Confirm Password</label>
                    <input type="password" id="confirm_password" name="confirm_password" placeholder="••••••••" required>
                </div>

                <div class="form-group">
                    <label for="profile_picture">Profile Picture</label>
                    <input type="file" id="profile_picture" name="profile_picture" accept="image/*">
                    <small style="color: #777; display: block; margin-top: 5px;">Please upload a clear facial portrait with a plain background.</small>
                </div>

                <button type="submit" class="btn-login">Sign Up <i class="fa-solid fa-user-plus"></i></button>
            </form>
            <div class="auth-footer">
                <span>Already have an account? <a href="login.php">Login</a></span>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>