<?php
require_once '../core/bootstrap.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$pageTitle = 'Account Settings';
include 'includes/header.php';

$userModel = new User();
$user = $userModel->getFullUserDetailsById($_SESSION['user_id']);

?>

<div class="page-content">
    <div class="matches-header">
        <h1>Account Settings</h1>
    </div>

    <?php if (isset($_GET['status'])): ?>
        <div class="status-message <?php echo $_GET['status'] === 'success' || $_GET['status'] === 'password_updated' ? 'success' : 'error'; ?>">
            <?php 
            if ($_GET['status'] === 'success') echo 'Profile updated successfully.';
            elseif ($_GET['status'] === 'password_updated') echo 'Password changed successfully.';
            elseif ($_GET['status'] === 'error') echo 'An error occurred. ' . htmlspecialchars($_GET['msg'] ?? '');
            ?>
        </div>
    <?php endif; ?>

    <div class="dashboard-section">
        <h2 class="dashboard-title">Profile Information</h2>
        <form action="settings_process.php" method="POST" enctype="multipart/form-data" class="styled-form">
            <input type="hidden" name="action" value="update_profile">
            
            <div class="form-group">
                <label for="profile_picture">Profile Picture</label>
                <?php if (!empty($user->profile_picture)): ?>
                    <div style="margin-bottom: 10px;">
                        <img src="<?php echo htmlspecialchars($user->profile_picture); ?>" alt="Profile" style="width: 80px; height: 80px; border-radius: 50%; object-fit: cover; border: 2px solid #eee;">
                    </div>
                <?php endif; ?>
                <input type="file" name="profile_picture" id="profile_picture" accept="image/*">
                <small style="color: #777;">Recommended: Square image, max 2MB.</small>
            </div>

            <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                <div class="form-group" style="flex: 1; min-width: 250px;">
                    <label for="first_name">First Name</label>
                    <input type="text" name="first_name" id="first_name" value="<?php echo htmlspecialchars($user->first_name); ?>" required>
                </div>
                <div class="form-group" style="flex: 1; min-width: 250px;">
                    <label for="last_name">Last Name</label>
                    <input type="text" name="last_name" id="last_name" value="<?php echo htmlspecialchars($user->last_name); ?>" required>
                </div>
            </div>

            <div class="form-group">
                <label for="username">Username</label>
                <input type="text" name="username" id="username" value="<?php echo htmlspecialchars($user->username); ?>" required>
            </div>

            <div class="form-group">
                <label for="email">Email Address</label>
                <input type="email" name="email" id="email" value="<?php echo htmlspecialchars($user->email); ?>" required>
            </div>

            <button type="submit" class="btn">Save Changes</button>
        </form>
    </div>

    <div class="dashboard-section">
        <h2 class="dashboard-title">Change Password</h2>
        <form action="settings_process.php" method="POST" class="styled-form">
            <input type="hidden" name="action" value="change_password">
            
            <div class="form-group">
                <label for="current_password">Current Password</label>
                <input type="password" name="current_password" id="current_password" required>
            </div>
            
            <div class="form-group">
                <label for="new_password">New Password</label>
                <input type="password" name="new_password" id="new_password" required minlength="6">
            </div>

            <div class="form-group">
                <label for="confirm_password">Confirm New Password</label>
                <input type="password" name="confirm_password" id="confirm_password" required minlength="6">
            </div>

            <button type="submit" class="btn btn-secondary">Update Password</button>
        </form>
    </div>
</div>

<style>
.status-message { padding: 15px; border-radius: 8px; margin-bottom: 20px; font-weight: 500; }
.status-message.success { background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
.status-message.error { background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
</style>

<?php include 'includes/footer.php'; ?>