<?php
require_once '../core/bootstrap.php';

// --- Authentication and Role Check ---
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'team_manager') {
    header('Location: login.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: my_team.php');
    exit();
}

$team_id = filter_input(INPUT_POST, 'team_id', FILTER_VALIDATE_INT);

$teamModel = new Team();
$team = $teamModel->getTeamByManagerId($_SESSION['user_id']);

if (!$team || $team->id != $team_id) {
    header('Location: my_team.php?error=auth_failed');
    exit();
}

if ($teamModel->updateRosterStatus($team_id, 'pending_approval')) {
    header('Location: my_team.php?status=roster_submitted');
} else {
    header('Location: my_team.php?error=submit_failed');
}
exit();
?>