<?php

class Follow {
    private $db;

    public function __construct() {
        $this->db = new Database;
    }

    // --- Player Follow Logic ---

    public function isFollowingPlayer($user_id, $player_id) {
        $this->db->query('SELECT COUNT(*) as count FROM user_follows_players WHERE user_id = :user_id AND player_id = :player_id');
        $this->db->bind(':user_id', $user_id);
        $this->db->bind(':player_id', $player_id);
        return $this->db->single()->count > 0;
    }

    public function followPlayer($user_id, $player_id) {
        $this->db->query('INSERT INTO user_follows_players (user_id, player_id) VALUES (:user_id, :player_id)');
        $this->db->bind(':user_id', $user_id);
        $this->db->bind(':player_id', $player_id);
        return $this->db->execute();
    }

    public function unfollowPlayer($user_id, $player_id) {
        $this->db->query('DELETE FROM user_follows_players WHERE user_id = :user_id AND player_id = :player_id');
        $this->db->bind(':user_id', $user_id);
        $this->db->bind(':player_id', $player_id);
        return $this->db->execute();
    }

    public function getFollowedPlayers($user_id) {
        $this->db->query('
            SELECT u.id as player_id, u.first_name, u.last_name, c.name as club_name, c.logo as club_logo
            FROM user_follows_players ufp
            JOIN users u ON ufp.player_id = u.id
            JOIN players p ON u.id = p.user_id
            JOIN teams t ON p.team_id = t.id
            JOIN clubs c ON t.club_id = c.id
            WHERE ufp.user_id = :user_id
            ORDER BY u.last_name ASC
        ');
        $this->db->bind(':user_id', $user_id);
        return $this->db->resultSet();
    }

    // --- Club Follow Logic ---

    public function isFollowingClub($user_id, $club_id) {
        $this->db->query('SELECT COUNT(*) as count FROM user_follows_clubs WHERE user_id = :user_id AND club_id = :club_id');
        $this->db->bind(':user_id', $user_id);
        $this->db->bind(':club_id', $club_id);
        return $this->db->single()->count > 0;
    }

    public function followClub($user_id, $club_id) {
        $this->db->query('INSERT INTO user_follows_clubs (user_id, club_id) VALUES (:user_id, :club_id)');
        $this->db->bind(':user_id', $user_id);
        $this->db->bind(':club_id', $club_id);
        return $this->db->execute();
    }

    public function unfollowClub($user_id, $club_id) {
        $this->db->query('DELETE FROM user_follows_clubs WHERE user_id = :user_id AND club_id = :club_id');
        $this->db->bind(':user_id', $user_id);
        $this->db->bind(':club_id', $club_id);
        return $this->db->execute();
    }

    public function getFollowedClubs($user_id) {
        $this->db->query('
            SELECT c.id, c.name, c.logo
            FROM user_follows_clubs ufc
            JOIN clubs c ON ufc.club_id = c.id
            WHERE ufc.user_id = :user_id
            ORDER BY c.name ASC
        ');
        $this->db->bind(':user_id', $user_id);
        return $this->db->resultSet();
    }
}
?>