<?php

class Notification extends Model {
    
    public function create($user_id, $type, $message) {
        $this->db->query("INSERT INTO notifications (user_id, type, message) VALUES (:uid, :type, :msg)");
        $this->db->bind(':uid', $user_id);
        $this->db->bind(':type', $type);
        $this->db->bind(':msg', $message);
        return $this->db->execute();
    }

    public function getUnreadByUserId($user_id) {
        $this->db->query("SELECT * FROM notifications WHERE user_id = :uid AND is_read = 0 ORDER BY created_at DESC");
        $this->db->bind(':uid', $user_id);
        return $this->db->resultSet();
    }

    public function markAsRead($id, $user_id) {
        $this->db->query("UPDATE notifications SET is_read = 1 WHERE id = :id AND user_id = :uid");
        $this->db->bind(':id', $id);
        $this->db->bind(':uid', $user_id);
        return $this->db->execute();
    }

    public function getAllByUser($user_id, $limit = 50) {
        $this->db->query("SELECT * FROM notifications WHERE user_id = :uid ORDER BY created_at DESC LIMIT :limit");
        $this->db->bind(':uid', $user_id);
        $this->db->bind(':limit', $limit, PDO::PARAM_INT);
        return $this->db->resultSet();
    }

    public function markAllAsRead($user_id) {
        $this->db->query("UPDATE notifications SET is_read = 1 WHERE user_id = :uid AND is_read = 0");
        $this->db->bind(':uid', $user_id);
        return $this->db->execute();
    }

}