<?php
$pageTitle = 'Injury List';
include 'includes/header.php';

// --- Authentication and Role Check ---
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'team_manager') {
    header('Location: login.php');
    exit();
}
$manager_id = $_SESSION['user_id'];

// --- Instantiate Models and Fetch Data ---
$teamModel = new Team();
$playerModel = new Player();

// Get the manager's team
$team = $teamModel->getTeamByManagerId($manager_id);

$injured_players = [];
if ($team) {
    // Get the currently injured players on the team
    $injured_players = $playerModel->getInjuredPlayersByTeamId($team->id);
}

?>

<div class="page-content">
    <div class="matches-header">
        <h1>Injury List</h1>
        <a href="/smart_football/app/add_injury.php" class="btn">Add Injury</a>
    </div>

    <?php if ($team): ?>
        <div class="dashboard-section">
            <h2 class="dashboard-title">Active Injuries</h2>
            <?php if (!empty($injured_players)): ?>
                <div class="table-wrapper">
                    <table class="styled-table">
                        <thead><tr><th>Player</th><th>Injury</th><th>Date Injured</th><th>Expected Return</th></tr></thead>
                        <tbody>
                            <?php foreach ($injured_players as $player): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($player->first_name . ' ' . $player->last_name); ?></td>
                                    <td><?php echo htmlspecialchars($player->injury_description); ?></td>
                                    <td><?php echo date('d M Y', strtotime($player->start_date)); ?></td>
                                    <td><?php echo $player->expected_return_date ? date('d M Y', strtotime($player->expected_return_date)) : 'N/A'; ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <p class="no-data-msg">No players are currently on the injury list.</p>
            <?php endif; ?>
        </div>
    <?php else: ?>
        <p class="no-data-msg">You are not currently assigned as a manager to any team.</p>
    <?php endif; ?>
</div>

<?php include 'includes/footer.php'; ?>