<?php
// This is a protected admin script.
// In a real application, you'd have robust admin authentication here.
require_once '../../core/bootstrap.php';

$pageTitle = 'Process Fantasy Points';
include '../includes/header.php'; // Basic header for feedback

$gameweek = filter_input(INPUT_GET, 'gameweek', FILTER_VALIDATE_INT);
$league_id = 1; // Assume Premier League for now

echo '<div class="page-content">';
echo '<h1>Processing Fantasy Points</h1>';

if (!$gameweek) {
    echo '<p class="error-msg">Please provide a valid gameweek number in the URL. Example: ?gameweek=1</p>';
} else {
    echo "<p>Attempting to process points for Gameweek: <strong>{$gameweek}</strong></p>";

    $fantasyPointsModel = new FantasyPoints();
    $result = $fantasyPointsModel->calculateForGameweek($gameweek, $league_id);

    $message_class = $result['status'] === 'success' ? 'success' : 'error';
    echo "<div class='status-message {$message_class}'>" . htmlspecialchars($result['message']) . "</div>";
}

echo '<p><a href="process_fantasy_points.php?gameweek=' . ($gameweek + 1) . '">Process Next Gameweek (' . ($gameweek + 1) . ')</a></p>';
echo '</div>';

include '../includes/footer.php';
?>