<?php
require_once '../core/bootstrap.php';

$league_id = filter_input(INPUT_GET, 'league_id', FILTER_VALIDATE_INT);
if (!$league_id) die('Invalid League ID.');

$fixture_model = new Fixture();
$fixtures = $fixture_model->getAllByLeague($league_id);

$league_model = new League();
$league_info = $league_model->getById($league_id);

$pageTitle = ($league_info->name ?? 'League') . ' Fixtures';
include_once 'includes/header.php';
?>

<h1><?php echo htmlspecialchars($league_info->name ?? 'League'); ?> Fixtures & Results</h1>

<div class="fixtures-list">
    <?php foreach ($fixtures as $fixture): ?>
        <div class="fixture-item">
            <div class="team home-team">
                <span class="team-name"><?php echo htmlspecialchars($fixture->home_team_name); ?></span>
                <img src="/smart_football/uploads/club_logos/<?php echo htmlspecialchars($fixture->home_team_logo ?? 'default.png'); ?>" class="table-logo">
            </div>
            <div class="score-box">
                <?php if ($fixture->status === 'finished' || $fixture->status === 'live'): ?>
                    <span class="score"><?php echo $fixture->home_team_score ?? 0; ?> - <?php echo $fixture->away_team_score ?? 0; ?></span>
                <?php else: ?>
                    <span class="time"><?php echo date('H:i', strtotime($fixture->match_datetime)); ?></span>
                    <span class="date"><?php echo date('d M Y', strtotime($fixture->match_datetime)); ?></span>
                <?php endif; ?>
            </div>
            <div class="team away-team">
                <img src="/smart_football/uploads/club_logos/<?php echo htmlspecialchars($fixture->away_team_logo ?? 'default.png'); ?>" class="table-logo">
                <span class="team-name"><?php echo htmlspecialchars($fixture->away_team_name); ?></span>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<?php include_once 'includes/footer.php'; ?>