<?php
// Bootstrap the application
require_once '../core/bootstrap.php';

// Instantiate models
$player = new Player();

// Get the player ID from the URL and validate it
$player_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

if (!$player_id) {
    // A simple error page for now
    die('Invalid Player ID.');
}

// Fetch all player data
$profile = $player->getFullProfile($player_id);
$stats = $player->getStats($player_id);

if (!$profile) {
    die('Player not found.');
}

// For demonstration, we'll create a basic header and footer here.
// In a full app, these would be in separate include files.
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($profile->first_name . ' ' . $profile->last_name); ?> - Player Profile</title>
    <link rel="stylesheet" href="assets/css/player_profile.css">
</head>
<body>

<div class="profile-container">
    <header class="profile-header">
        <img src="/smart_football/uploads/profile_pictures/<?php echo htmlspecialchars($profile->profile_picture); ?>" alt="Profile Picture" class="profile-picture">
        <div class="player-info">
            <h1><?php echo htmlspecialchars($profile->first_name . ' ' . $profile->last_name); ?></h1>
            <h2>#<?php echo htmlspecialchars($profile->squad_number); ?> - <?php echo htmlspecialchars($profile->position); ?></h2>
            <div class="club-info">
                <img src="/smart_football/uploads/club_logos/<?php echo htmlspecialchars($profile->club_logo ?? 'default.png'); ?>" alt="Club Logo" class="club-logo">
                <span><?php echo htmlspecialchars($profile->club_name); ?></span>
            </div>
        </div>
    </header>

    <main class="profile-main">
        <section class="stats-section">
            <h3>Season Statistics</h3>
            <div class="stats-grid">
                <div class="stat-item">
                    <span class="stat-value"><?php echo htmlspecialchars($stats->goals); ?></span>
                    <span class="stat-label">Goals</span>
                </div>
                <div class="stat-item">
                    <span class="stat-value"><?php echo htmlspecialchars($stats->assists); ?></span>
                    <span class="stat-label">Assists</span>
                </div>
                <div class="stat-item">
                    <span class="stat-value"><?php echo htmlspecialchars($stats->yellow_cards); ?></span>
                    <span class="stat-label">Yellow Cards</span>
                </div>
                <div class="stat-item">
                    <span class="stat-value"><?php echo htmlspecialchars($stats->red_cards); ?></span>
                    <span class="stat-label">Red Cards</span>
                </div>
            </div>
        </section>

        <section class="bio-section">
            <h3>About</h3>
            <p><?php echo nl2br(htmlspecialchars($profile->bio ?? 'No biography available.')); ?></p>
        </section>
    </main>
</div>

</body>
</html>